#include <a_samp>
#define FILTERSCRIPT

new Text:Clock; new Text:Den;

forward GetWeekdayNum(d,m,y);
forward settime();
forward weatherchange();

public OnFilterScriptInit()
{
        print("\n========================================================");
        print("====== Msi-Life.my1.ru======");
        print("========================================================\n");

        Den = TextDrawCreate(549.000000,55.000000,"----");
        TextDrawAlignment(Den,0);
        TextDrawBackgroundColor(Den,0x000000ff);
        TextDrawFont(Den,3);
        TextDrawLetterSize(Den,0.399999,1.000000);
        TextDrawColor(Den,0x00ff00ff);
        TextDrawSetOutline(Den,1);
        TextDrawSetProportional(Den,1);
        TextDrawSetShadow(Den,1);

        Clock = TextDrawCreate(548.000000,22.000000, "--:--");
        TextDrawLetterSize(Clock, 0.599999,2.200000);
        TextDrawFont(Clock, 3);
        TextDrawColor(Clock,0xffff00ff);
        TextDrawSetOutline(Clock, 1);

        SetTimer("settime",1000,true);
        SetTimer("weatherchange",10800000,true);
        return 1;
}

public OnFilterScriptExit()
{
        return 1;
}

public OnPlayerSpawn(playerid)
{
        TextDrawShowForPlayer(playerid, Clock);
        TextDrawShowForPlayer(playerid, Den);
        SendClientMessage(playerid, 0xFF0000AA, "Msi-Life");
        return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
        TextDrawHideForPlayer(playerid, Clock);
        TextDrawHideForPlayer(playerid, Den);
        return 1;
}

public weatherchange(){
        SetWeather(random(18));
}

public settime(){
        new hour,minute,second;
        new string[256];
        gettime(hour,minute,second);
        if (minute <= 9){format(string,25,"%d:0%d",hour,minute);}
        else {format(string,25,"%d:%d",hour,minute);}
        TextDrawSetString(Clock,string);
        SetWorldTime(hour);
        new day, month, year;
        new weekday;
        getdate(day, month, year);
        weekday = GetWeekdayNum(day, month, year);
        if(weekday == 1){TextDrawSetString(Den,"");}
        if(weekday == 2){TextDrawSetString(Den,"");}
        if(weekday == 3){TextDrawSetString(Den,"");}
        if(weekday == 4){TextDrawSetString(Den,"");}
        if(weekday == 5){TextDrawSetString(Den,"");}
        if(weekday == 6){TextDrawSetString(Den,"");}
        if(weekday == 7){TextDrawSetString(Den,"");}
        return 1;
}

public GetWeekdayNum(d,m,y) //by d.wine
{
        m-=2;
        if(m<=0)
                {
                y--;
                m+=12;
                }
        new cen = y/100;
        y=getrem(y,100);
        new w = d + ((13*m-1)/5) + y + (y/4) + (cen/4) - 2*cen;
        w=getrem(w,7);
        if (w==0) w=7;
        return w-1;
}

getrem(a,b) //get remnant of division
{
        new div = a/b;
        new left = a-b*div;
        return left;
}
